use "adsilc_eco_integrato.dta", clear

sort id_individuo
merge m:1 id_individuo using "sample_itsilc.dta"
keep if _merge==3 | _merge==2
gen source = _merge-2
label variable source "0 if never in INPS, 1 if in INPS"
drop _merge

*We shall drop these observations because we will not have province of birth
drop if source==0

replace inizio_period="19900701" if inizio_periodo=="11900701"   
replace fine_periodo="19870526" if fine_periodo=="19878709"
replace fine_periodo="19920220" if fine_periodo=="19920002"
replace fine_periodo="19860228" if fine_periodo=="19860229"

replace fine_periodo="19890106" if fine_periodo=="19890600"
replace fine_periodo="19850831" if fine_periodo=="19850931"
replace fine_periodo="19820516" if fine_periodo=="19820500"

* Generate start and end of job episodes
gen a_ini=substr(inizio_period, 1,4)
gen m_ini=substr(inizio_period, 5,2)
gen g_ini=substr(inizio_period, 7,2)
gen a_fin=substr(fine_period, 1,4)
gen m_fin=substr(fine_period, 5,2)
gen g_fin=substr(fine_period, 7,2)
*******************************************************************
destring a_ini, replace
gen skill=substr(qualifica,1,1) if a_ini>1997

gen qual=1 if skill=="3" | skill=="9"| skill=="C" | skill=="D"| skill=="Q" 
replace qual=2 if skill=="2" | skill=="A" | skill=="E" | skill=="F" | skill=="G" | skill=="H" | skill=="L" | skill=="M" | skill=="N" ///
				| skill=="P" | skill=="S"
replace qual=3 if skill=="1" | skill=="4" | skill=="5" | skill=="6" | skill=="7" | skill=="8" | skill=="B" | skill=="O" | skill=="R" ///
				| skill=="T" | skill=="W" | skill=="Z"

replace qual=1 if (qualifica=="PRO"| qualifica=="3" | qualifica=="9"| qualifica=="C" | qualifica=="D"| qualifica=="Q") & a_ini<1998 
replace qual=2 if (qualifica=="2" | qualifica=="A" | qualifica=="E" | qualifica=="F" | qualifica=="G" | qualifica=="H" | qualifica=="L" | qualifica=="M" | qualifica=="N" ///
				 | qualifica=="S"| qualifica=="Y") & a_ini<1998 
replace qual=3 if (qualifica=="1" | qualifica=="4" | qualifica=="5" | qualifica=="6" | qualifica=="7" | qualifica=="8" | qualifica=="B" | qualifica=="O"| qualifica=="P" | qualifica=="R" ///
				| qualifica=="T" | qualifica=="V"| qualifica=="W"| qualifica=="X" | qualifica=="Z"| qualifica=="COL"| qualifica=="DOM"| qualifica=="OTI"| qualifica=="OTD") & a_ini<1998 				
replace qual=3 if fondo=="PALS" & qualifica=="1"
replace qual=2 if fondo=="PALS" & qualifica=="2"
replace qual=3 if fondo=="PALS" & qualifica=="3"				
label variable qual "Qualifica"
label define qual 1 "Manager" 2 "White-collar" 3 "Blue-collar", replace
label values qual qual
drop skill
tostring a_ini, replace

********************************************************************
*This to take into account that at the end of each year a new line is created as if a new job episode starts
destring a_fin, replace
destring a_ini, replace

expand 2 if a_fin!=a_ini, generate(expanded)
replace expanded=. if a_fin==a_ini
replace g_fin="31" 	if expanded==0 
replace m_fin="12" 	if expanded==0 
replace a_fin=a_fin-1 	if expanded==0

replace g_ini="01" 	if expanded==1
replace m_ini="01" 	if expanded==1 
replace a_ini=a_ini+1 	if expanded==1

tostring a_fin, replace
tostring a_ini, replace

generate ini_2 =inizio_periodo
generate fin_2 =fine_periodo

replace inizio_periodo=a_ini+m_ini+g_ini if expanded==1
replace fine_periodo=a_fin+m_fin+g_fin if expanded==0

gen start= date(inizio_periodo,"YMD")
gen end= date(fine_periodo,"YMD")
gen length=end-start
drop if length<0
*** 10 obs deleted
replace length=length+1
destring tipo_contr, replace
*************************************************************************************************
*This is to set to 0 the contract duration if there was no payment for the labour activity
*************************************************************************************************
count if length>0 & retribuzione==0 & (tipo_contr==1 | tipo_contr==2 | tipo_contr==19)
replace length=0 if length>0 & retribuzione==0 & (tipo_contr==1 | tipo_contr==2 | tipo_contr==19)
count if length>0 & retribuzione==0 & (tipo_contr==1 | tipo_contr==2 | tipo_contr==19)
*************************************************************************************************
*************************************************************************************************
gen start2= date(ini_2,"YMD")
gen end2= date(fin_2,"YMD")
gen length2=end2-start2+1
*************************************************************************************************
*This is to set to 0 the contract duration if there was no payment for the labour activity
*************************************************************************************************
count if length2>0 & retribuzione==0 & (tipo_contr==1 | tipo_contr==2 | tipo_contr==19)
replace length2=0 if length2>0 & retribuzione==0 & (tipo_contr==1 | tipo_contr==2 | tipo_contr==19)
count if length2>0 & retribuzione==0 & (tipo_contr==1 | tipo_contr==2 | tipo_contr==19)
*************************************************************************************************
*************************************************************************************************
replace retrib=retrib*length/length2  if (expanded==0 | expanded==1) & retribuzione>0 

drop start2 end2 length2 ini_2 fin_2

count if a_ini!=a_fin
gen pio=1 if a_ini!=a_fin
replace pio=0 if pio==.
bysort id_ind: egen pio1=max(pio)
tab pio1
drop if pio1==1
drop pio pio1

********************************************************************
cap drop rat
gen rat=contr_misura/contr_diritto
replace rat=1 if rat>1
replace rat=1 if rat==0 

cap drop leng_fte
gen 	 leng_fte=length
replace  leng_fte=length*rat

cap drop w
cap drop w_fte
cap drop y
bysort id_ind a_ini: egen w    =total(retrib)          if tipo_contr==1 | tipo_contr==2 | tipo_contr==19
bysort id_ind a_ini: egen t_len=total(leng_fte) if tipo_contr==1 | tipo_contr==2 | tipo_contr==19
gen w_fte=w/t_len if tipo_contr==1 | tipo_contr==2 | tipo_contr==19
bysort id_ind a_ini: egen y=total(retrib)
label variable w "reddito da lavoro"
label variable w_fte "fte earnings per day of contract"
label variable y "reddito totale"

tab tipo_con, sum(retrib)
gen motivo=1 if tipo_contr==1 | tipo_contr==2 | tipo_contr==19
replace motivo=2 if tipo_contr==4 | tipo_contr==5 | tipo_contr==6 | tipo_contr==12| tipo_contr==13 | tipo_contr==14 | tipo_contr==15| tipo_contr==16 | tipo_contr==17 | tipo_contr==18 | tipo_contr==21
replace motivo=3 if tipo_contr==7 | tipo_contr==10 | tipo_contr==11
replace motivo=4 if tipo_contr==8
replace motivo=5 if tipo_contr==9
label define motivo 1 "contr per lavoro" 2 "contr. volontario" 3 "contri. per disocc. cig..." 4 "contr. per malattia" 5 "contr.maternita"

cap drop partime
gen partime=0
replace partime=1 if rat<=0.75 & motivo==1
cap drop fulltime
gen fulltime=0
replace fulltime=1 if rat>0.75 & motivo==1

rename anno_na nascita
rename a_ini anno

set seed 123456789
gen rand=uniform()
gsort id_ind anno motivo -retribuzione m_ini g_ini m_fin g_fin rand
bysort id_ind anno: egen seqq=seq()

gsort id_ind anno motivo start

*Generate number of days in employment
preserve
keep if motivo==1
local k = 1
while `k'>0 {
count if id_ind==id_ind[_n-1] & anno==anno[_n-1] & start>=start[_n-1] & end<=end[_n-1] 
local k=r(N)
drop if id_ind==id_ind[_n-1] & anno==anno[_n-1] & start>=start[_n-1] & end<=end[_n-1]
}

gsort id_ind start
local k = 1
while `k'>0 {
count if id_ind==id_ind[_n+1] & anno==anno[_n+1] & start[_n+1]<=end+1  
local k=r(N)
gen end2=end[_n+1] if id_ind==id_ind[_n+1] & anno==anno[_n+1] & start[_n+1]<=end+1
drop if id_ind==id_ind[_n-1] & anno==anno[_n-1] & start<=end[_n-1]+1
replace end=end2 if end2!=.
cap drop end2 
}

gen leng=end-start+1
*************************************************************************************************
*This is to set to 0 the contract duration if there was no payment for the labour activity
*************************************************************************************************
count if leng>0 & retribuzione==0 & (tipo_contr==1 | tipo_contr==2 | tipo_contr==19)
replace leng=0 if leng>0 & retribuzione==0 & (tipo_contr==1 | tipo_contr==2 | tipo_contr==19)
count if leng>0 & retribuzione==0 & (tipo_contr==1 | tipo_contr==2 | tipo_contr==19)
*************************************************************************************************
*************************************************************************************************
bysort id_ind anno: egen totday=total(leng)
sum totday 

cap drop seqq
bysort id_ind anno: egen seqq=seq()
keep if seqq==1
keep totday anno id_ind
save "totday.dta", replace
restore

*Generate number of days in part-time employment
preserve
keep if partime==1
local k = 1
while `k'>0 {
count if id_ind==id_ind[_n-1] & anno==anno[_n-1] & start>=start[_n-1] & end<=end[_n-1] 
local k=r(N)
drop if id_ind==id_ind[_n-1] & anno==anno[_n-1] & start>=start[_n-1] & end<=end[_n-1]
}

gsort id_ind start
local k = 1
while `k'>0 {
count if id_ind==id_ind[_n+1] & anno==anno[_n+1] & start[_n+1]<=end+1  
local k=r(N)
gen end2=end[_n+1] if id_ind==id_ind[_n+1] & anno==anno[_n+1] & start[_n+1]<=end+1
drop if id_ind==id_ind[_n-1] & anno==anno[_n-1] & start<=end[_n-1]+1
replace end=end2 if end2!=.
cap drop end2 
}

gen leng=end-start+1
*************************************************************************************************
*This is to set to 0 the contract duration if there was no payment for the labour activity 
*************************************************************************************************
count if leng>0 & retribuzione==0 & (tipo_contr==1 | tipo_contr==2 | tipo_contr==19)
replace leng=0 if leng>0 & retribuzione==0 & (tipo_contr==1 | tipo_contr==2 | tipo_contr==19)
count if leng>0 & retribuzione==0 & (tipo_contr==1 | tipo_contr==2 | tipo_contr==19)
*************************************************************************************************
*************************************************************************************************

bysort id_ind anno: egen totday_pt=total(leng)

cap drop seqq
bysort id_ind anno: egen seqq=seq()
keep if seqq==1
keep totday_pt anno id_ind
save "totday_pt.dta", replace
restore

*Generate number of days in full-time employment
preserve
keep if fulltime==1
local k = 1
while `k'>0 {
count if id_ind==id_ind[_n-1] & anno==anno[_n-1] & start>=start[_n-1] & end<=end[_n-1] 
local k=r(N)
drop if id_ind==id_ind[_n-1] & anno==anno[_n-1] & start>=start[_n-1] & end<=end[_n-1]
}

gsort id_ind start
local k = 1
while `k'>0 {
count if id_ind==id_ind[_n+1] & anno==anno[_n+1] & start[_n+1]<=end+1  
local k=r(N)
gen end2=end[_n+1] if id_ind==id_ind[_n+1] & anno==anno[_n+1] & start[_n+1]<=end+1
drop if id_ind==id_ind[_n-1] & anno==anno[_n-1] & start<=end[_n-1]+1
replace end=end2 if end2!=.
cap drop end2 
}

gen leng=end-start+1
*************************************************************************************************
*This is to set to 0 the contract duration if there was no payment for the labour activity
*************************************************************************************************
count if leng>0 & retribuzione==0 & (tipo_contr==1 | tipo_contr==2 | tipo_contr==19)
replace leng=0 if leng>0 & retribuzione==0 & (tipo_contr==1 | tipo_contr==2 | tipo_contr==19)
count if leng>0 & retribuzione==0 & (tipo_contr==1 | tipo_contr==2 | tipo_contr==19)
*************************************************************************************************
*************************************************************************************************
bysort id_ind anno: egen totday_ft=total(leng)

cap drop seqq
bysort id_ind anno: egen seqq=seq()
keep if seqq==1
keep totday_ft anno id_ind
save "totday_ft.dta", replace
restore

merge m:m id_ind anno using "totday_ft.dta"
drop _merge

merge m:m id_ind anno using "totday_pt.dta"
drop _merge

merge m:m id_ind anno using "totday.dta"
drop _merge

*************************************************************************************
*Keep only one line per individual, a job if motivo==1, something else is motivo>1
keep if seqq==1
drop seqq

cap drop pub priv prof
gen pub=0
replace pub=1 if tiporaplav=="D"
gen priv=0
replace priv=1 if tiporaplav=="I"
gen prof=0
replace prof=1 if tiporaplav=="P"

destring anno, replace
tab anno if anno>1976, sum(w)
tab anno if anno>1976, sum(y)

rename id_individuo pid
merge m:1 pid using "cleaned_itsilc.dta"
keep if _merge==3
drop _merge

cap drop reg_res
gen reg_res=0
replace reg_res=1 if    prov_res=="TO"|prov_res=="VC"|prov_res=="BI"|prov_res=="NO"|prov_res=="CN"|prov_res=="AT"|prov_res=="AL"|prov_res=="VB" // Piemonte
replace reg_res=2 if	prov_res=="AO"																					      					// Valle d'Aosta
replace reg_res=3 if	prov_res=="BG"|prov_res=="BS"|prov_res=="CO"|prov_res=="CR"|prov_res=="LC"|prov_res=="LO"|prov_res=="MN"|prov_res=="MI"| ///
						prov_res=="VA"|prov_res=="SO"|prov_res=="PV"|prov_res=="MB"								       							// Lombardia		
replace reg_res=4 if	prov_res=="BZ"|prov_res=="TN"																							// Trentino-Alto Adige
replace reg_res=5 if	prov_res=="VR"|prov_res=="VI"|prov_res=="BL"|prov_res=="TV"|prov_res=="VE"| prov_res=="PD"|prov_res=="RO" 				//Veneto 												// Veneto
replace reg_res=6 if	prov_res=="GO"|prov_res=="PN"|prov_res=="UD"|prov_res=="TS"																// Friuli-Venezia Giulia
replace reg_res=7 if	prov_res=="GE"|prov_res=="IM"|prov_res=="SP"|prov_res=="SV"																// Liguria
replace reg_res=8 if	prov_res=="PC"|prov_res=="PR"|prov_res=="RE"|prov_res=="MO"|prov_res=="BO"|prov_res=="FE"|prov_res=="RA"| ///
						prov_res=="FC"|prov_res=="RN"																							// Emilia-Romagna
replace reg_res=9 if	prov_res=="AR"|prov_res=="FI"|prov_res=="GR"|prov_res=="LI"|prov_res=="LU"|prov_res=="MS"|prov_res=="PT"|prov_res=="PI"| ///
						prov_res=="PO"|prov_res=="SI" 																							// Toscana	
replace reg_res=10 if	prov_res=="PG"|prov_res=="TR"																							// Umbria
replace reg_res=11 if	prov_res=="AN"|prov_res=="AP"|prov_res=="MC"|prov_res=="PU"|prov_res=="FM"												// Marche
replace reg_res=12 if	prov_res=="VT"|prov_res=="RI"|prov_res=="RM"|prov_res=="FR"|prov_res=="LT"												// Lazio
replace reg_res=13 if	prov_res=="AQ"|prov_res=="CH"|prov_res=="TE"|prov_res=="PE"																// Abruzzo
replace reg_res=14 if	prov_res=="CB"|prov_res=="IS"																							// Molise
replace reg_res=15 if	prov_res=="AV"|prov_res=="BN"|prov_res=="CE"|prov_res=="NA"|prov_res=="SA"												// Campania
replace reg_res=16 if	prov_res=="BA"|prov_res=="BR"|prov_res=="BT"|prov_res=="FG"|prov_res=="LE"|prov_res=="TA"								// Puglia
replace reg_res=17 if	prov_res=="MT"|prov_res=="PZ" 																							// Basilicata
replace reg_res=18 if	prov_res=="CZ"|prov_res=="CS"|prov_res=="KR"|prov_res=="VV"|prov_res=="RC" 												// Calabria
replace reg_res=19 if	prov_res=="TP"|prov_res=="PA"|prov_res=="AG"|prov_res=="CL"|prov_res=="CT"|prov_res=="RG"|prov_res=="SR"|prov_res=="EN"| ///
						prov_res=="ME" 																									 		// Sicilia
replace reg_res=20 if	prov_res=="CA"|prov_res=="SS"|prov_res=="NU"|prov_res=="OR"|prov_res=="OT"|prov_res=="OG"|prov_res=="VS"|prov_res=="CI" // Sardegna
label variable reg_res "Region of residence"
label define reg 0 "Missing" 1 "Piemonte" 2 "Valle dAosta" 3 "Lombardia" 4 "Trentino-Alto-Adige" 5 "Veneto" 6 "Friuli-Venezia Giulia" 7 "Liguria" 8 "Emilia-Romagna" 9 "Toscana" ///
				 10 "Umbria" 11 "Marche" 12 "Lazio" 13 "Abruzzo" 14 "Molise" 15 "Campania" 16 "Puglia" 17 "Basilicata" 18 "Calabria" 19 "Sicilia" 20 "Sardegna", replace
label value reg reg_res

gen     reg_nas=0
replace reg_nas=1  if regione=="Piemonte"
replace reg_nas=2  if regione=="Valle d'Aosta"
replace reg_nas=3  if regione=="Lombardia"
replace reg_nas=4  if regione=="Trentino-Alto Adige"
replace reg_nas=5  if regione=="Veneto"
replace reg_nas=6  if regione=="Friuli-Venezia Giulia"
replace reg_nas=7  if regione=="Liguria"
replace reg_nas=8  if regione=="Emilia-Romagna"
replace reg_nas=9  if regione=="Toscana"
replace reg_nas=10 if regione=="Umbria"
replace reg_nas=11 if regione=="Marche"
replace reg_nas=12 if regione=="Lazio"
replace reg_nas=13 if regione=="Abruzzo"
replace reg_nas=14 if regione=="Molise"
replace reg_nas=15 if regione=="Campania"
replace reg_nas=16 if regione=="Puglia"
replace reg_nas=17 if regione=="Basilicata"
replace reg_nas=18 if regione=="Calabria"
replace reg_nas=19 if regione=="Sicilia"
replace reg_nas=20 if regione=="Sardegna"
label variable reg_nas "Region of birth"
label value reg reg_nas

forvalues k = 1 (1) 21 {
gen w`k'     = w if anno-pe030==`k'
gen w_fte`k' = w_fte if anno-pe030==`k'
gen y`k'     = y if anno-pe030==`k'
}

forvalues k = 1 (1) 21{
gen tday`k'   = totday if anno-pe030==`k'
gen tdaypt`k' = totday_pt if anno-pe030==`k'
gen tdayft`k' = totday_ft if anno-pe030==`k'
}

*id_azienda k years after diploma 
 forvalues k = 1 (1) 21{
gen id_azienda`k' = id_azienda if anno-pe030==`k'
bys pid: egen sid_azienda`k'=sum(id_azienda`k')
}

*partime k years after diploma 
 forvalues k = 1 (1) 21{
gen partime`k' = partime if anno-pe030==`k'
bys pid: egen spartime`k'=sum(partime`k')
}

*occupation k years after diploma 
 forvalues k = 1 (1) 21{
gen qual`k' = qual if anno-pe030==`k'
bys pid: egen squal`k'=sum(qual`k')
}

*pubblico k years after diploma 
 forvalues k = 1 (1) 21{
gen pub`k' = pub if anno-pe030==`k'
bys pid: egen spub`k'=sum(pub`k')
}

*privato k years after diploma 
 forvalues k = 1 (1) 21{
gen priv`k' = priv if anno-pe030==`k'
bys pid: egen spriv`k'=sum(priv`k')
}

sort pid anno

bysort pid: egen primo_anno=min(anno)
bysort pid: egen ultimo_anno=max(anno)

*generate labor earnings in the years before diploma
forvalues k = 0 (1) 3 {
cap drop pip
gen pip=w if anno==pe030-`k'
bys pid: egen lab_ear_`k'=total(pip)
drop pip
label variable lab_ear_`k' "Labor earnings `k' years before the diploma"
}

*generate total days of work in the years before diploma
forvalues k = 0 (1) 3 {
cap drop pip
gen pip=0
replace pip=totday if anno==pe030-`k'
bys pid: egen totday_`k'=total(pip)
replace totday_`k'=totday_`k'/365.25
drop pip
label variable totday_`k' "% of days at work `k' years before the diploma"
}
*generate total days of work in the years before diploma
forvalues k = 0 (1) 3 {
gen inps_anno_`k'=pe030-`k'
}

****# lab_earn_i and tot_inc_i are the cumulated until i of the incomes from the year of education
forvalues k = 1 (1) 21{
bys pid: egen lab_ear`k'=sum(w`k')
label variable lab_ear`k' "Labor earnings `k' years after diploma"
}
forvalues k = 1 (1) 21{
bys pid: egen lab_wag`k'=sum(w_fte`k')
label variable lab_wag`k' "FTE daily wage `k' years after diploma"
}
forvalues k = 1 (1) 21{
bys pid: egen tot_inc`k'=sum(y`k')
label variable tot_inc`k' "Total income `k' years after diploma"
}
forvalues k = 1 (1) 21{
gen inps_anno`k'=pe030+`k'
label variable inps_anno`k' "Calendar year `k' years after diploma"
}

forvalues k = 1 (1) 21{
gen regr`k' = reg_res if anno-pe030==`k'
bys pid: egen reg_res`k'=sum(regr`k')
replace reg_res`k'=reg_nas if reg_res`k'==0
label variable reg_res`k' "Region of residence `k' years after diploma"
}

forvalues k = 1 (1) 21{
bys pid: egen totday`k'=sum(tday`k')
label variable totday`k' "% of days at work `k' years after diploma"
}
forvalues k = 1 (1) 21{
bys pid: egen totday_pt`k'=sum(tdaypt`k')
label variable totday_pt`k' "% of days in part-time work `k' years after diploma"
}
forvalues k = 1 (1) 21{
bys pid: egen totday_ft`k'=sum(tdayft`k')
label variable totday_ft`k' "% of days in full-time work `k' years after diploma"
}

gen inps_anno0=inps_anno_0
forvalues k = 0 (1) 21{
gen kid1_`k'=1 if (inps_anno`k'==child_ybirth_9m1)
}
forvalues k = 1 (1) 21{
gen kid2_`k'=1 if (inps_anno`k'==child_ybirth_9m2)
gen kid3_`k'=1 if (inps_anno`k'==child_ybirth_9m3)
}

forv i=0 (1) 20 {
local  j=`i'+1
replace kid1_`j'=kid1_`i' if kid1_`j'==.
}
forv i=1 (1) 20 {
local  j=`i'+1
replace kid2_`j'=kid2_`i' if kid2_`j'==.
replace kid3_`j'=kid3_`i' if kid3_`j'==.
}
replace kid1_1=kid1_0 if kid1_0==1
drop kid1_0

forvalues k=1 (1) 21{
egen num_kids_`k'=rowtotal (kid1_`k' kid2_`k' kid3_`k')
label variable num_kids_`k' "Numero dei figli `k' years after diploma"
}

forvalues k = 0 (1) 21{
gen child1_`k'=1 if (inps_anno`k'==child_ybirth_9m1)
}
replace child1_1=1 if child1_0==1
drop  child1_0
forvalues k = 1 (1) 21{
gen child2_`k'=1 if (inps_anno`k'==child_ybirth_9m2)
gen child3_`k'=1 if (inps_anno`k'==child_ybirth_9m3)
}
drop inps_anno0

forvalues k = 1 (1) 21{
replace totday`k'=totday`k'/365 if inps_anno`k'!=1976&inps_anno`k'!=1980&inps_anno`k'!=1984&inps_anno`k'!=1988&inps_anno`k'!=1992&inps_anno`k'!=1996&inps_anno`k'!=2000& ///
								   inps_anno`k'!=2004&inps_anno`k'!=2008&inps_anno`k'!=2012
replace totday`k'=totday`k'/366 if inps_anno`k'==1976|inps_anno`k'==1980|inps_anno`k'==1984|inps_anno`k'==1988|inps_anno`k'==1992|inps_anno`k'==1996|inps_anno`k'==2000| ///
								   inps_anno`k'==2004|inps_anno`k'==2008|inps_anno`k'==2012
replace totday_pt`k'=totday_pt`k'/365 if inps_anno`k'!=1976&inps_anno`k'!=1980&inps_anno`k'!=1984&inps_anno`k'!=1988&inps_anno`k'!=1992&inps_anno`k'!=1996&inps_anno`k'!=2000& ///
								   inps_anno`k'!=2004&inps_anno`k'!=2008&inps_anno`k'!=2012
replace totday_pt`k'=totday_pt`k'/366 if inps_anno`k'==1976|inps_anno`k'==1980|inps_anno`k'==1984|inps_anno`k'==1988|inps_anno`k'==1992|inps_anno`k'==1996|inps_anno`k'==2000| ///
								   inps_anno`k'==2004|inps_anno`k'==2008|inps_anno`k'==2012
replace totday_ft`k'=totday_ft`k'/365 if inps_anno`k'!=1976&inps_anno`k'!=1980&inps_anno`k'!=1984&inps_anno`k'!=1988&inps_anno`k'!=1992&inps_anno`k'!=1996&inps_anno`k'!=2000& ///
								   inps_anno`k'!=2004&inps_anno`k'!=2008&inps_anno`k'!=2012
replace totday_ft`k'=totday_ft`k'/366 if inps_anno`k'==1976|inps_anno`k'==1980|inps_anno`k'==1984|inps_anno`k'==1988|inps_anno`k'==1992|inps_anno`k'==1996|inps_anno`k'==2000| ///
								   inps_anno`k'==2004|inps_anno`k'==2008|inps_anno`k'==2012
}

forvalues k = 0 (1) 3 {
replace lab_ear_`k'=. if inps_anno_`k'>2011 & anno_silc==2011
replace lab_ear_`k'=. if inps_anno_`k'>2005 & anno_silc==2005
*********************************************************
*Labor earnings before diploma in 2014 proces
replace lab_ear_`k'=lab_ear_`k'*14.373 if inps_anno_`k'==1973
replace lab_ear_`k'=lab_ear_`k'*12.033 if inps_anno_`k'==1974
replace lab_ear_`k'=lab_ear_`k'*10.270 if inps_anno_`k'==1975
replace lab_ear_`k'=lab_ear_`k'*8.814 if inps_anno_`k'==1976
replace lab_ear_`k'=lab_ear_`k'*7.463 if inps_anno_`k'==1977
replace lab_ear_`k'=lab_ear_`k'*6.637 if inps_anno_`k'==1978
replace lab_ear_`k'=lab_ear_`k'*5.735 if inps_anno_`k'==1979
replace lab_ear_`k'=lab_ear_`k'*4.734 if inps_anno_`k'==1980
replace lab_ear_`k'=lab_ear_`k'*3.988 if inps_anno_`k'==1981
replace lab_ear_`k'=lab_ear_`k'*3.428 if inps_anno_`k'==1982
replace lab_ear_`k'=lab_ear_`k'*2.981 if inps_anno_`k'==1983
replace lab_ear_`k'=lab_ear_`k'*2.696 if inps_anno_`k'==1984
replace lab_ear_`k'=lab_ear_`k'*2.482 if inps_anno_`k'==1985
replace lab_ear_`k'=lab_ear_`k'*2.340 if inps_anno_`k'==1986
replace lab_ear_`k'=lab_ear_`k'*2.236 if inps_anno_`k'==1987
replace lab_ear_`k'=lab_ear_`k'*2.131 if inps_anno_`k'==1988
replace lab_ear_`k'=lab_ear_`k'*1.999 if inps_anno_`k'==1989
replace lab_ear_`k'=lab_ear_`k'*1.884 if inps_anno_`k'==1990
replace lab_ear_`k'=lab_ear_`k'*1.770 if inps_anno_`k'==1991
replace lab_ear_`k'=lab_ear_`k'*1.679 if inps_anno_`k'==1992
replace lab_ear_`k'=lab_ear_`k'*1.612 if inps_anno_`k'==1993
replace lab_ear_`k'=lab_ear_`k'*1.551 if inps_anno_`k'==1994
replace lab_ear_`k'=lab_ear_`k'*1.472 if inps_anno_`k'==1995
replace lab_ear_`k'=lab_ear_`k'*1.417 if inps_anno_`k'==1996
replace lab_ear_`k'=lab_ear_`k'*1.392 if inps_anno_`k'==1997
replace lab_ear_`k'=lab_ear_`k'*1.368 if inps_anno_`k'==1998
replace lab_ear_`k'=lab_ear_`k'*1.347 if inps_anno_`k'==1999
replace lab_ear_`k'=lab_ear_`k'*1.313 if inps_anno_`k'==2000
replace lab_ear_`k'=lab_ear_`k'*1.279 if inps_anno_`k'==2001
replace lab_ear_`k'=lab_ear_`k'*1.248 if inps_anno_`k'==2002
replace lab_ear_`k'=lab_ear_`k'*1.218 if inps_anno_`k'==2003
replace lab_ear_`k'=lab_ear_`k'*1.195 if inps_anno_`k'==2004
replace lab_ear_`k'=lab_ear_`k'*1.175 if inps_anno_`k'==2005
replace lab_ear_`k'=lab_ear_`k'*1.152 if inps_anno_`k'==2006
replace lab_ear_`k'=lab_ear_`k'*1.132 if inps_anno_`k'==2007
replace lab_ear_`k'=lab_ear_`k'*1.097 if inps_anno_`k'==2008
replace lab_ear_`k'=lab_ear_`k'*1.089 if inps_anno_`k'==2009
replace lab_ear_`k'=lab_ear_`k'*1.072 if inps_anno_`k'==2010
replace lab_ear_`k'=lab_ear_`k'*1.044 if inps_anno_`k'==2011
replace lab_ear_`k'=lab_ear_`k'*1.013 if inps_anno_`k'==2012
replace lab_ear_`k'=lab_ear_`k'*1.002 if inps_anno_`k'==2013
}

forvalues k = 1 (1) 21{
replace lab_ear`k'=. if inps_anno`k'>2011 & anno_silc==2011
replace lab_wag`k'=. if inps_anno`k'>2011 & anno_silc==2011
replace tot_inc`k'=. if inps_anno`k'>2011 & anno_silc==2011
replace totday`k'=. if inps_anno`k'>2011 & anno_silc==2011
replace totday_pt`k'=. if inps_anno`k'>2011 & anno_silc==2011
replace totday_ft`k'=. if inps_anno`k'>2011 & anno_silc==2011
replace reg_res`k'=. if inps_anno`k'>2011 & anno_silc==2011
replace lab_ear`k'=. if inps_anno`k'>2005 & anno_silc==2005
replace lab_wag`k'=. if inps_anno`k'>2005 & anno_silc==2005
replace tot_inc`k'=. if inps_anno`k'>2005 & anno_silc==2005
replace totday`k'=. if inps_anno`k'>2005 & anno_silc==2005
replace totday_pt`k'=. if inps_anno`k'>2005 & anno_silc==2005
replace totday_ft`k'=. if inps_anno`k'>2005 & anno_silc==2005
replace reg_res`k'=. if inps_anno`k'>2005 & anno_silc==2005
*********************************************************
*Labor earnings in 2014 prices
replace lab_ear`k'=lab_ear`k'*7.463 if inps_anno`k'==1977
replace lab_ear`k'=lab_ear`k'*6.637 if inps_anno`k'==1978
replace lab_ear`k'=lab_ear`k'*5.735 if inps_anno`k'==1979
replace lab_ear`k'=lab_ear`k'*4.734 if inps_anno`k'==1980
replace lab_ear`k'=lab_ear`k'*3.988 if inps_anno`k'==1981
replace lab_ear`k'=lab_ear`k'*3.428 if inps_anno`k'==1982
replace lab_ear`k'=lab_ear`k'*2.981 if inps_anno`k'==1983
replace lab_ear`k'=lab_ear`k'*2.696 if inps_anno`k'==1984
replace lab_ear`k'=lab_ear`k'*2.482 if inps_anno`k'==1985
replace lab_ear`k'=lab_ear`k'*2.340 if inps_anno`k'==1986
replace lab_ear`k'=lab_ear`k'*2.236 if inps_anno`k'==1987
replace lab_ear`k'=lab_ear`k'*2.131 if inps_anno`k'==1988
replace lab_ear`k'=lab_ear`k'*1.999 if inps_anno`k'==1989
replace lab_ear`k'=lab_ear`k'*1.884 if inps_anno`k'==1990
replace lab_ear`k'=lab_ear`k'*1.770 if inps_anno`k'==1991
replace lab_ear`k'=lab_ear`k'*1.679 if inps_anno`k'==1992
replace lab_ear`k'=lab_ear`k'*1.612 if inps_anno`k'==1993
replace lab_ear`k'=lab_ear`k'*1.551 if inps_anno`k'==1994
replace lab_ear`k'=lab_ear`k'*1.472 if inps_anno`k'==1995
replace lab_ear`k'=lab_ear`k'*1.417 if inps_anno`k'==1996
replace lab_ear`k'=lab_ear`k'*1.392 if inps_anno`k'==1997
replace lab_ear`k'=lab_ear`k'*1.368 if inps_anno`k'==1998
replace lab_ear`k'=lab_ear`k'*1.347 if inps_anno`k'==1999
replace lab_ear`k'=lab_ear`k'*1.313 if inps_anno`k'==2000
replace lab_ear`k'=lab_ear`k'*1.279 if inps_anno`k'==2001
replace lab_ear`k'=lab_ear`k'*1.248 if inps_anno`k'==2002
replace lab_ear`k'=lab_ear`k'*1.218 if inps_anno`k'==2003
replace lab_ear`k'=lab_ear`k'*1.195 if inps_anno`k'==2004
replace lab_ear`k'=lab_ear`k'*1.175 if inps_anno`k'==2005
replace lab_ear`k'=lab_ear`k'*1.152 if inps_anno`k'==2006
replace lab_ear`k'=lab_ear`k'*1.132 if inps_anno`k'==2007
replace lab_ear`k'=lab_ear`k'*1.097 if inps_anno`k'==2008
replace lab_ear`k'=lab_ear`k'*1.089 if inps_anno`k'==2009
replace lab_ear`k'=lab_ear`k'*1.072 if inps_anno`k'==2010
replace lab_ear`k'=lab_ear`k'*1.044 if inps_anno`k'==2011
replace lab_ear`k'=lab_ear`k'*1.013 if inps_anno`k'==2012
replace lab_ear`k'=lab_ear`k'*1.002 if inps_anno`k'==2013
*********************************************************
*Daily wage in 2014 prices
replace lab_wag`k'=lab_wag`k'*7.463 if inps_anno`k'==1977
replace lab_wag`k'=lab_wag`k'*6.637 if inps_anno`k'==1978
replace lab_wag`k'=lab_wag`k'*5.735 if inps_anno`k'==1979
replace lab_wag`k'=lab_wag`k'*4.734 if inps_anno`k'==1980
replace lab_wag`k'=lab_wag`k'*3.988 if inps_anno`k'==1981
replace lab_wag`k'=lab_wag`k'*3.428 if inps_anno`k'==1982
replace lab_wag`k'=lab_wag`k'*2.981 if inps_anno`k'==1983
replace lab_wag`k'=lab_wag`k'*2.696 if inps_anno`k'==1984
replace lab_wag`k'=lab_wag`k'*2.482 if inps_anno`k'==1985
replace lab_wag`k'=lab_wag`k'*2.340 if inps_anno`k'==1986
replace lab_wag`k'=lab_wag`k'*2.236 if inps_anno`k'==1987
replace lab_wag`k'=lab_wag`k'*2.131 if inps_anno`k'==1988
replace lab_wag`k'=lab_wag`k'*1.999 if inps_anno`k'==1989
replace lab_wag`k'=lab_wag`k'*1.884 if inps_anno`k'==1990
replace lab_wag`k'=lab_wag`k'*1.770 if inps_anno`k'==1991
replace lab_wag`k'=lab_wag`k'*1.679 if inps_anno`k'==1992
replace lab_wag`k'=lab_wag`k'*1.612 if inps_anno`k'==1993
replace lab_wag`k'=lab_wag`k'*1.551 if inps_anno`k'==1994
replace lab_wag`k'=lab_wag`k'*1.472 if inps_anno`k'==1995
replace lab_wag`k'=lab_wag`k'*1.417 if inps_anno`k'==1996
replace lab_wag`k'=lab_wag`k'*1.392 if inps_anno`k'==1997
replace lab_wag`k'=lab_wag`k'*1.368 if inps_anno`k'==1998
replace lab_wag`k'=lab_wag`k'*1.347 if inps_anno`k'==1999
replace lab_wag`k'=lab_wag`k'*1.313 if inps_anno`k'==2000
replace lab_wag`k'=lab_wag`k'*1.279 if inps_anno`k'==2001
replace lab_wag`k'=lab_wag`k'*1.248 if inps_anno`k'==2002
replace lab_wag`k'=lab_wag`k'*1.218 if inps_anno`k'==2003
replace lab_wag`k'=lab_wag`k'*1.195 if inps_anno`k'==2004
replace lab_wag`k'=lab_wag`k'*1.175 if inps_anno`k'==2005
replace lab_wag`k'=lab_wag`k'*1.152 if inps_anno`k'==2006
replace lab_wag`k'=lab_wag`k'*1.132 if inps_anno`k'==2007
replace lab_wag`k'=lab_wag`k'*1.097 if inps_anno`k'==2008
replace lab_wag`k'=lab_wag`k'*1.089 if inps_anno`k'==2009
replace lab_wag`k'=lab_wag`k'*1.072 if inps_anno`k'==2010
replace lab_wag`k'=lab_wag`k'*1.044 if inps_anno`k'==2011
replace lab_wag`k'=lab_wag`k'*1.013 if inps_anno`k'==2012
replace lab_wag`k'=lab_wag`k'*1.002 if inps_anno`k'==2013
*********************************************************
*Total income in 2014 prices
replace tot_inc`k'=tot_inc`k'*7.463 if inps_anno`k'==1977
replace tot_inc`k'=tot_inc`k'*6.637 if inps_anno`k'==1978
replace tot_inc`k'=tot_inc`k'*5.735 if inps_anno`k'==1979
replace tot_inc`k'=tot_inc`k'*4.734 if inps_anno`k'==1980
replace tot_inc`k'=tot_inc`k'*3.988 if inps_anno`k'==1981
replace tot_inc`k'=tot_inc`k'*3.428 if inps_anno`k'==1982
replace tot_inc`k'=tot_inc`k'*2.981 if inps_anno`k'==1983
replace tot_inc`k'=tot_inc`k'*2.696 if inps_anno`k'==1984
replace tot_inc`k'=tot_inc`k'*2.482 if inps_anno`k'==1985
replace tot_inc`k'=tot_inc`k'*2.340 if inps_anno`k'==1986
replace tot_inc`k'=tot_inc`k'*2.236 if inps_anno`k'==1987
replace tot_inc`k'=tot_inc`k'*2.131 if inps_anno`k'==1988
replace tot_inc`k'=tot_inc`k'*1.999 if inps_anno`k'==1989
replace tot_inc`k'=tot_inc`k'*1.884 if inps_anno`k'==1990
replace tot_inc`k'=tot_inc`k'*1.770 if inps_anno`k'==1991
replace tot_inc`k'=tot_inc`k'*1.679 if inps_anno`k'==1992
replace tot_inc`k'=tot_inc`k'*1.612 if inps_anno`k'==1993
replace tot_inc`k'=tot_inc`k'*1.551 if inps_anno`k'==1994
replace tot_inc`k'=tot_inc`k'*1.472 if inps_anno`k'==1995
replace tot_inc`k'=tot_inc`k'*1.417 if inps_anno`k'==1996
replace tot_inc`k'=tot_inc`k'*1.392 if inps_anno`k'==1997
replace tot_inc`k'=tot_inc`k'*1.368 if inps_anno`k'==1998
replace tot_inc`k'=tot_inc`k'*1.347 if inps_anno`k'==1999
replace tot_inc`k'=tot_inc`k'*1.313 if inps_anno`k'==2000
replace tot_inc`k'=tot_inc`k'*1.279 if inps_anno`k'==2001
replace tot_inc`k'=tot_inc`k'*1.248 if inps_anno`k'==2002
replace tot_inc`k'=tot_inc`k'*1.218 if inps_anno`k'==2003
replace tot_inc`k'=tot_inc`k'*1.195 if inps_anno`k'==2004
replace tot_inc`k'=tot_inc`k'*1.175 if inps_anno`k'==2005
replace tot_inc`k'=tot_inc`k'*1.152 if inps_anno`k'==2006
replace tot_inc`k'=tot_inc`k'*1.132 if inps_anno`k'==2007
replace tot_inc`k'=tot_inc`k'*1.097 if inps_anno`k'==2008
replace tot_inc`k'=tot_inc`k'*1.089 if inps_anno`k'==2009
replace tot_inc`k'=tot_inc`k'*1.072 if inps_anno`k'==2010
replace tot_inc`k'=tot_inc`k'*1.044 if inps_anno`k'==2011
replace tot_inc`k'=tot_inc`k'*1.013 if inps_anno`k'==2012
replace tot_inc`k'=tot_inc`k'*1.002 if inps_anno`k'==2013
}

compress

save "working.dta", replace


forvalues k = 1 (1) 21{
use "reg_year77.dta"
drop reg regione pe030 rgdp dgdp_one_year
rename reg_res reg_res`k' 
rename anno inps_anno`k'
rename tfr tfr`k'
rename er er`k'
rename ur ur`k'
sort reg_res`k' inps_anno`k'
save "reg_year77_`k'", replace
}

use "working.dta", clear

forvalues k = 1 (1) 21{
sort reg_res`k' inps_anno`k' 
merge m:1 reg_res`k' inps_anno`k' using "reg_year77_`k'.dta"
drop if _merge==2
drop _merge
}

cap drop seq*
bysort pid anno_silc: egen seqq=seq()

*FROM THIS POINT ONWARDS THE DATSETS BECOMES WIDE (1 line per woman)
keep if seqq==1

drop seqq w1-y15 tday1-tdayft15 
drop id_azienda1-id_azienda15 partime1-partime15 qual1-qual15 pub1-pub15 priv1-priv15

drop if d_morte!=.
drop expanded sesso anno d_morte pb110
drop totday_pt totday prov_res prov_lav retribuzione motivo
drop kid1_1-kid3_21

save "mle_data.dta", replace 
